/*
Name: lu_chartype_tables.sql
author: Ganesh Thadkamalla
Date: 1/1/2007
description:  creates lu_chartype and characteristic_chartype tables and its data.
Modifications: 
1/8/2007 - added (10,201) -GT.
3/11/2007 - Removed Measure N records. Added unique constraint to characteristic_chartype table - GT.



comments: When ever there are new characteristics in di_characteristic table that are not Taxa, they should classified and appropriate insert statements should be added to the script.  This addition is manual process as the analysis of new characteristic classification is necessary.

*/

spool lu_chartype_tables.log


show user;
DROP table characteristic_chartype;
drop table lu_chartype;
create table lu_chartype
(pk_isn number,
chartype varchar2(256),
description varchar2(4000));

alter table lu_chartype
add constraint pk_chartype primary Key (pk_isn)
using index
tablespace storetindx
storage (initial 256k next 256K);

comment on table lu_chartype is 'Characteristic Types lookup table.' ;

comment on column lu_chartype.pk_isn is 'Chartype lookup table primary key' ;
comment on column lu_chartype.chartype is 'Chartype shot names.' ;
comment on column lu_chartype.description is 'Chartype description.' ;


-- insert data

insert into lu_chartype (pk_isn,chartype,description)
values (1,'Biological','Biological characteristics');

insert into lu_chartype (pk_isn,chartype,description)
values (2,'Habitat','Habitat related characteristics');

insert into lu_chartype (pk_isn,chartype,description)
values (3,'Metal','Metals');

--insert into lu_chartype (pk_isn,chartype,description)
--values (4,'Measure N','Tribal Measure');

insert into lu_chartype (pk_isn,chartype,description)
values (5,'Microbiological','Microbiologicals');

insert into lu_chartype (pk_isn,chartype,description)
values (6,'Nutrient','Nutrients');

insert into lu_chartype (pk_isn,chartype,description)
values (7,'Other','Organics, Inorganics and others');

insert into lu_chartype (pk_isn,chartype,description)
values (8,'PCB','Polychlorinated Biphenyls');

insert into lu_chartype (pk_isn,chartype,description)
values (9,'Pesticide','Pesticides');

insert into lu_chartype (pk_isn,chartype,description)
values (10,'Physical','Physicals and chemical characteristics');

insert into lu_chartype (pk_isn,chartype,description)
values (11,'Radiation','Radioactive isotopes');

commit;

create index ichartype01 on lu_chartype (chartype)
tablespace storetindx
storage (initial 256k next 256K);


--characteristic chartype association table
--DROP table characteristic_chartype;
Create table characteristic_chartype
  (fk_chartype number not null,
   Fk_characteristic number not null)
  Tablespace storetdata
  Storage (initial 2M next 2M);

ALTER TABLE CHARACTERISTIC_CHARTYPE ADD CONSTRAINT CFK_CHARTYPE FOREIGN KEY (FK_CHARTYPE) REFERENCING LU_CHARTYPE(PK_ISN);

ALTER TABLE CHARACTERISTIC_CHARTYPE ADD CONSTRAINT CFK_CHAR FOREIGN KEY (FK_CHARACTERISTIC) REFERENCING DI_CHARACTERISTIC(PK_ISN);

ALTER TABLE CHARACTERISTIC_CHARTYPE ADD CONSTRAINT CPK_CHAR_CHARTYPE primary KEY (FK_CHARACTERISTIC,FK_CHARTYPE)
using index
tablespace storetindx
storage (initial 2M next 2M);


CREATE unique INDEX UICCT01 ON CHARACTERISTIC_CHARTYPE(FK_CHARTYPE,FK_CHARACTERISTIC)
TABLESPACE STORETINDX
STORAGE (INITIAL 2 m NEXT 2M);



comment on table characteristic_chartype is 'Characteristic CharType association table.' ;

comment on column characteristic_chartype.fk_chartype is 'Foreign key referencing Chartype.' ;
comment on column characteristic_chartype.Fk_characteristic is 'Foreign key referencing Characteristic.' ;






INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,2);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,3);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,4);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,5);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,6);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,8);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,9);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,10);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,11);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,12);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,13);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,14);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,17);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,19);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,21);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,22);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,23);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,24);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,25);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,26);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,28);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,29);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,30);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,31);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,32);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,33);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,34);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,35);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,36);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,37);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,41);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,43);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,44);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,45);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,46);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,47);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,48);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,49);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,50);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,51);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,52);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,53);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,58);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,59);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,60);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,61);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,62);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,63);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,64);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,65);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,66);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,67);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,68);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,69);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,70);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,72);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,73);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,74);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,75);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,76);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,77);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,78);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,79);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,80);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,81);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,82);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,83);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,85);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,86);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,87);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,88);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,89);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,90);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,91);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,93);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,94);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,95);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,98);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,99);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,100);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,101);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,103);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,104);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,105);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,106);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,107);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,108);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,109);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,110);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,111);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,112);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,115);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,116);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,117);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,118);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,119);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,121);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,122);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,123);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,125);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,127);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,128);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,129);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,130);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,134);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,135);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,136);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,138);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,139);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,140);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,141);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,142);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,143);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,144);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,145);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,146);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,147);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,148);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,149);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,150);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,152);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,153);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,162);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,163);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,164);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,165);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,166);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,167);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,168);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,169);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,170);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,171);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,172);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,174);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,175);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,176);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,177);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,178);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,179);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,180);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,181);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,182);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,183);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,184);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,185);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,186);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,187);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,188);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,189);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,190);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,191);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,192);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,193);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,194);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,195);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,196);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,197);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,198);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,199);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,200);

INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,202);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,203);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,204);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,205);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,208);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,209);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,210);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,211);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,212);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,213);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,214);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,215);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,216);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,221);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,222);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,223);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,224);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,227);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,228);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,229);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,230);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,231);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,233);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,234);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,235);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,244);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,246);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,247);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,248);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,249);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,250);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,251);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,253);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,254);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,255);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,256);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,257);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,258);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,260);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,261);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,262);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,264);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,265);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,266);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,267);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,268);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,269);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,270);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,274);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,275);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,277);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,278);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,279);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,280);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,281);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,282);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,285);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,287);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,288);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,289);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,290);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,291);

commit;

INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,295);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,296);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,297);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,298);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,299);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,300);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,301);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,302);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,303);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,304);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,305);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,306);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,307);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,308);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,309);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,311);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,312);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,313);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,314);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,315);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,316);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,317);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,318);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,319);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,320);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,321);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,324);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,325);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,326);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,327);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,328);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,329);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,330);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,331);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,333);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,334);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,335);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,336);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,337);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,338);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,339);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,340);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,341);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,343);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,344);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,345);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,347);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,348);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,350);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,351);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,353);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,354);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,356);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,357);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,358);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,359);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,360);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,362);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,363);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,364);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,365);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,366);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,367);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,369);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,370);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,371);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,372);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,373);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,374);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,375);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,376);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,377);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,378);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,379);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,381);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,382);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,383);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,384);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,386);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,387);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,389);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,390);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,392);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,393);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,400);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,401);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,402);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,403);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,404);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,405);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,406);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,411);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,412);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,413);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,414);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,415);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,416);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,417);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,418);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,419);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,420);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,422);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,423);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,424);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,425);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,426);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,427);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,430);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,431);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,432);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,433);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,435);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,438);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,439);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,440);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,442);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,443);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,444);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,445);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,446);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,447);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,448);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,449);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,450);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,452);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,453);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,456);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,457);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,464);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,465);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,466);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,467);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,468);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,469);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,470);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,471);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,473);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,474);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,475);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,478);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,479);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,480);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,482);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,483);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,484);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,485);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,486);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,488);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,489);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,493);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,494);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,495);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,496);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,497);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,498);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,499);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,500);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,501);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,502);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,503);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,504);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,505);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,506);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,507);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,508);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,509);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,510);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,511);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,512);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,513);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,516);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,517);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,518);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,519);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,522);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,525);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,526);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,531);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,540);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,541);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,542);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,543);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,544);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,545);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,546);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,547);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,548);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,549);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,614);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,618);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,619);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,620);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,621);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,622);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,623);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,624);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,625);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,626);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,627);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,628);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,629);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,631);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,632);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,633);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,634);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,636);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,637);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,638);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,639);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,641);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,642);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,643);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,644);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,646);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,647);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,648);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,649);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,650);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,652);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,653);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,654);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,655);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,656);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,657);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,658);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,659);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,660);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,661);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,662);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,663);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,664);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,665);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,667);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,668);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,669);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,670);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,672);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,673);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,674);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,675);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,676);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,677);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,678);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,679);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,680);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,681);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,682);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,683);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,684);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,685);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,686);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,687);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,688);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,689);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,690);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,691);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,692);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,694);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,695);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,697);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,699);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,700);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,703);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,704);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,705);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,706);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,707);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,708);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,709);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,710);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,711);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,712);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,713);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,714);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,715);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,716);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,717);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,718);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,719);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,720);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,721);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,722);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,723);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,724);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,725);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,726);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,727);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,728);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,729);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,730);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,731);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,732);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,733);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,735);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,736);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,737);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,738);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,740);
commit;

INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,741);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,742);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,743);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,744);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,745);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,747);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,748);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,749);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,750);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,751);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,752);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,753);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,754);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,755);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,756);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,757);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,758);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,760);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,761);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,763);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,764);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,765);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,766);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,767);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,768);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,769);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,771);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,772);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,773);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,774);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,775);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,777);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,778);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,779);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,780);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,781);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,782);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,783);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,784);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,785);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,787);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,788);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,789);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,790);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,791);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,792);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,793);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,794);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,795);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,796);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,797);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,798);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,799);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,800);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,801);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,802);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,803);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,804);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,805);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,806);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,807);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,808);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,809);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,810);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,811);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,812);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,813);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,815);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,816);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,817);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,818);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,819);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,820);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,821);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,822);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,823);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,824);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,825);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,826);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,827);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,828);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,829);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,831);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,832);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,833);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,834);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,835);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,836);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,837);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,839);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,840);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,841);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,842);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,843);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,844);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,845);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,846);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,847);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,848);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,849);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,850);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,851);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,852);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,853);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,854);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,856);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,857);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,858);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,859);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,860);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,861);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,862);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,863);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,864);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,865);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,867);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,868);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,869);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,870);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,871);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,872);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,873);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,874);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,875);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,876);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,877);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,878);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,880);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,882);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,883);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,884);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,885);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,886);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,887);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,888);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,889);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,890);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,891);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,892);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,894);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,895);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,896);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,897);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,898);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,899);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,900);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,901);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,902);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,903);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,904);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,905);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,906);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,907);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,909);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,910);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,912);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,913);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,914);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,915);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,916);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,917);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,918);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,919);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,920);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,921);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,922);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,923);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,924);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,925);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,926);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,927);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,928);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,929);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,930);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,931);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,932);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,933);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,934);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,935);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,936);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,937);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,938);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,939);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,940);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,941);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,942);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,943);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,944);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,945);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,946);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,947);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,948);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,949);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,950);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,951);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,952);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,953);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,954);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,956);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,957);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,958);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,959);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,960);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,961);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,962);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,966);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,967);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,968);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,969);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,970);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,971);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,972);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,973);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,974);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,975);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,976);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,977);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,978);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,979);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,980);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,981);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,982);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,984);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,985);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,986);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,987);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,988);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,989);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,990);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,991);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,992);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,993);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,994);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,995);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,996);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,997);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,998);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,999);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1001);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1002);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1003);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1005);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1006);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1007);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1008);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1009);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1011);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1012);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1013);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1015);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1016);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1017);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1018);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1019);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1020);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1021);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1022);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1023);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1024);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1025);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1026);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1027);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1028);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1029);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1030);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1031);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1033);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1034);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1035);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1036);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1037);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1038);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1039);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1040);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1041);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1042);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1045);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1046);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1047);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1048);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1049);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1050);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1051);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1052);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1054);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1055);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1056);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1057);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1058);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1059);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1060);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1061);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1062);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1063);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1064);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1065);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1066);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1067);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1068);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1069);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1070);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1071);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1072);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1073);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1074);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1075);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1077);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1078);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1079);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1080);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1081);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1082);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1083);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1084);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1085);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1086);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1087);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1088);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1089);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1091);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1092);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1093);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1094);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1095);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1096);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1097);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1098);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1099);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1100);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1101);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1102);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1103);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1104);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1105);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1106);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1107);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1108);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1109);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1111);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1112);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1113);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1114);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1115);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1116);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1118);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1120);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1121);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1122);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1123);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1124);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1126);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1127);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1128);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1129);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1130);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1131);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1132);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1133);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1135);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1136);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1138);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1139);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1140);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1141);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1142);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1143);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1144);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1145);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1148);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1149);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1150);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1151);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1152);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,1153);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1154);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1155);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1157);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1158);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1159);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1160);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1161);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1162);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1163);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1164);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1165);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1167);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1168);
commit;

INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1169);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1170);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1171);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1172);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1173);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1174);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1175);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1177);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1178);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1179);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1180);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1181);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1182);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1183);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1184);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1185);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1186);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1187);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1188);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1189);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1190);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1191);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1192);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1193);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1195);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1196);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1197);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1198);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1199);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1200);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1201);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1202);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1203);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1204);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1205);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1206);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1207);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1208);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1209);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1210);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1211);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1212);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1213);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1214);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1215);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1216);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1217);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1218);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1220);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1221);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1222);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1223);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1224);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1225);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1226);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1227);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1228);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1229);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1230);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1231);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1232);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1233);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1234);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1235);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1236);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1237);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1238);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1239);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1240);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1242);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1243);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1244);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1245);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1246);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1247);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1249);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1250);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1251);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1252);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1253);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1254);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1255);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1256);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1257);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1258);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1259);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1262);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1263);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1264);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1265);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1266);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1267);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1268);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1270);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1271);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1272);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,1273);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,1274);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,1275);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1276);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1277);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1278);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1279);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1280);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1281);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1282);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1285);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1286);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1287);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1288);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1289);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1290);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1291);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1292);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1293);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1294);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1295);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1296);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1297);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1298);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1299);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1300);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1301);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1302);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1303);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1304);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1305);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1306);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1308);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1309);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1310);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1311);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1312);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1313);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1314);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1315);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1316);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1317);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1318);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1319);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1320);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1321);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1322);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1323);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1324);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1325);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1326);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1327);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1328);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1330);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1331);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1332);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1333);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1334);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1335);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1336);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1337);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1338);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1339);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1340);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1341);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1342);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1343);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1344);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1345);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1346);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1347);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1348);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1349);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1350);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1352);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1353);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1354);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1356);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1357);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1358);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1359);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1360);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1361);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1362);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1363);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1364);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1365);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1367);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1368);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1369);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1370);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1371);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1372);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1373);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1375);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1376);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1377);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1378);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1380);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1381);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1382);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1383);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1384);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1385);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1386);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1387);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1389);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1390);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1391);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1392);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1393);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1394);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1395);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1397);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1398);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1400);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1401);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1402);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1403);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1404);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1405);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1406);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1408);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1409);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1410);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1411);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1412);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1413);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1414);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1415);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1416);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1417);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1418);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1420);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1422);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1423);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1424);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1425);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1426);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1427);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1428);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1429);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1430);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1431);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1432);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1433);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1434);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1436);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1437);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1438);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1439);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1440);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1441);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1442);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1443);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1444);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1445);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1446);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1447);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1448);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1449);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,1450);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,1451);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1452);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1453);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1454);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1455);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1456);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1457);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1458);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1459);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1460);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1461);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1462);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1463);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1464);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1465);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1466);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1468);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1469);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1470);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1471);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1472);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,1473);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1474);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,1475);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,1476);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,1477);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1478);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1480);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1481);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1482);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1483);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1484);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1486);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1487);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1488);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1489);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1491);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1493);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1494);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1496);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1497);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1498);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1499);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1500);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1501);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1502);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1503);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1504);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1505);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1506);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1507);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1508);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1509);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1511);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1512);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1513);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1514);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1516);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1517);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1518);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1520);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1523);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1525);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1526);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1527);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1528);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1530);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1531);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1532);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1533);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1534);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1535);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1536);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1537);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1538);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1539);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1541);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1542);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1543);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1544);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1545);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1546);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1547);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1549);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1550);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1584);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1586);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1587);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1588);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1589);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1590);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1591);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1592);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1593);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1595);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1596);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1598);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1599);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1601);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1602);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1603);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1605);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1606);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1607);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1608);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1609);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1610);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1611);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1612);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1613);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1614);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1615);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1616);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1617);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1618);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1619);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1620);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1621);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1622);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1623);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1624);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1625);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1626);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1627);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1628);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1629);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1630);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1631);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1632);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1633);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1634);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1638);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1639);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1640);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1641);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1642);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1643);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1644);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1645);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1648);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1649);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1650);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1651);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1652);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1653);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1654);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1655);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1656);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1657);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1658);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1659);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1660);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1661);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1662);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1663);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1664);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1665);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1666);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1667);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1668);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1669);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1670);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1671);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1672);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1673);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1674);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1675);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1678);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1679);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1680);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,1681);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1682);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1683);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1684);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1685);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1686);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1687);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1688);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1689);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1690);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1692);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1693);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1694);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1695);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1697);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1698);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,1700);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1701);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1702);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1703);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1704);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1705);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1706);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1707);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1708);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1709);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1710);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1711);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1712);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1714);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1715);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1716);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1717);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1718);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1719);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1720);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1721);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1722);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1723);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1724);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1725);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1726);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1727);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1728);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1729);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1730);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,9787);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,9788);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,9789);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,9790);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,9791);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,9792);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,9793);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,9794);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,9795);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,9797);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,9800);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,11696);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11698);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11703);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11704);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,11705);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,11706);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,11707);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,11708);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,11709);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,11710);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,11711);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11712);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11713);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11714);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11715);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11716);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11717);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11718);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11719);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11720);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11736);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11737);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11738);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11739);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11741);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11742);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11745);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11746);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11747);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11748);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11749);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11750);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11751);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11752);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11753);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11754);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11755);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11756);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11758);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11759);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11760);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,11761);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,11767);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,11769);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11770);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,11776);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,11781);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,11786);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,11791);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,11797);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,11798);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,11805);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,11806);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,11807);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,11808);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11809);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11810);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,14479);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14480);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,14482);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14488);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14490);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14491);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14492);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14493);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14494);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14496);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14497);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14498);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14499);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14500);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14501);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14503);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14504);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14505);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14506);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14507);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14508);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,14509);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,14510);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14511);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14512);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14513);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14514);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15837);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15838);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15839);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,15840);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15852);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15853);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15854);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15855);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15856);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15858);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15859);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15860);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15861);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15862);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15863);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15864);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15865);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15866);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15867);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15868);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15869);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15870);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15872);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15873);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15874);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15875);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,15876);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,15877);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15878);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15879);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15880);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15881);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15882);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15883);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15884);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15885);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15887);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15888);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15889);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15890);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15891);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15892);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15893);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15894);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15895);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15896);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15897);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15898);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15900);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15901);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15903);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15904);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15905);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15906);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15907);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15908);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,15910);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15911);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15912);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15913);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15914);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15915);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15916);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15917);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15918);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15919);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15920);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15921);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15923);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15924);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15925);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15927);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15928);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15929);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15930);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15931);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15932);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15933);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15934);
commit;

INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15935);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15936);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15937);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15938);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15939);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15940);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15941);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,15942);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15943);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15944);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15945);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15947);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15948);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,15949);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,15975);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15977);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15978);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,15979);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15980);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,15981);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,15982);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15984);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,15985);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15986);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15987);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15988);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,15989);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,15990);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15992);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15993);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15994);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15995);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15996);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,15997);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15998);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15999);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16000);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16001);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16002);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16004);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16005);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,16006);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16007);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16008);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,16009);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16010);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16011);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16012);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16013);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16014);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16015);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16016);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16017);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16018);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16019);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16020);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16021);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16022);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16023);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16024);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16026);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16029);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16030);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16031);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16033);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16034);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16037);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16039);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16042);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16044);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16045);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16046);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16047);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16049);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16050);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16052);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16055);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16057);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16059);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16061);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16063);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16064);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16065);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16066);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16072);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16080);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16081);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16082);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16083);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16085);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16086);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16089);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16092);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16093);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16094);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16096);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16097);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16098);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,16100);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16101);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16102);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,16103);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16104);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16106);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16107);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16108);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16109);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16110);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16111);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16112);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16113);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16114);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16118);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16119);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16121);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16123);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16124);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16126);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16129);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16130);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16131);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16133);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16134);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16136);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16137);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16138);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16139);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16140);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16141);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16142);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16143);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16146);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16149);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16150);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16151);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16152);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16153);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16154);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16155);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16156);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16157);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16158);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16160);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16161);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16162);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16163);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16164);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16165);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16166);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16167);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16169);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16170);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16172);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16173);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16175);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16176);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16177);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16179);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16180);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16182);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16184);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16185);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16186);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16187);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16188);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16189);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16190);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16191);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16193);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16195);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16197);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16199);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16200);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16201);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16202);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16204);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16206);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16210);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16259);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16260);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16261);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16262);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16263);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16264);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16265);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16266);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16269);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16270);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16272);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16273);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16274);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16275);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16276);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16277);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16278);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16279);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16281);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16282);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16283);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16284);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16285);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16286);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16287);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16289);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16291);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16292);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16293);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16294);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16295);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16296);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16297);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16298);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16299);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16300);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16301);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16303);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16304);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16305);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16307);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16308);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16309);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16310);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16311);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16315);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16316);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16318);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16319);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16320);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16321);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16322);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16323);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16324);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16325);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16326);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16328);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,16329);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16336);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16337);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16415);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16562);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16564);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16565);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16566);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16567);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16568);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16569);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16570);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16571);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16572);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16573);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16574);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16575);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16576);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16578);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16579);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16580);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16581);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16583);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16584);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16585);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16586);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16588);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16589);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16590);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16591);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16592);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16593);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16917);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16918);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16919);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16920);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16922);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16923);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16924);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,337511);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,337512);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,337513);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,20);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,27);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,38);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,39);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,42);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,54);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,55);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,56);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,57);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,96);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,120);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,131);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,132);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,133);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,151);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,154);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,155);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,156);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,157);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,158);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,159);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,160);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,206);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,217);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,218);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,219);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,220);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,236);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,237);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,238);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,239);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,240);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,241);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,242);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,243);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,252);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,273);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,276);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,283);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,284);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,286);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,292);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,293);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,342);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,346);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,349);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,355);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,361);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,388);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,391);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,394);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,395);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,396);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,397);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,398);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,408);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,409);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,410);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,428);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,429);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,436);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,437);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,441);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,454);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,455);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,458);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,459);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,460);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,461);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,462);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,463);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,476);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,477);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,481);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,490);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,491);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,492);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,515);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,520);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,521);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,527);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,528);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,529);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,530);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,532);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,533);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,534);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,535);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,536);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,537);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,538);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,539);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,551);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,552);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,553);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,554);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,555);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,556);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,557);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,558);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,559);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,560);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,561);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,562);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,563);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,564);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,565);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,566);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,567);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,568);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,569);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,570);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,571);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,572);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,573);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,574);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,575);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,576);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,577);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,578);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,579);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,580);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,581);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,582);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,583);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,584);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,585);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,586);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,587);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,588);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,589);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,590);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,591);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,592);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,593);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,594);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,595);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,596);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,597);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,598);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,599);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,600);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,601);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,602);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,603);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,604);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,605);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,606);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,607);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,608);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,609);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,610);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,611);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,612);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,613);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,615);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,616);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,617);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,693);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,698);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,702);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,830);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,963);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,964);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,965);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1137);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1146);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1490);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1492);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1519);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1521);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1548);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1551);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1552);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1553);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1554);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1555);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1556);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1557);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1558);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1559);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1560);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1561);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1562);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1563);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1564);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1565);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1566);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1567);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1568);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1569);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1570);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1571);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1572);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1573);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1574);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1575);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1576);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1577);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1578);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1579);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1580);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1581);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1582);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,1583);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1594);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1600);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1635);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1636);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1637);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1731);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,1732);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,2324);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,2325);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,2326);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,2327);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,2328);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,2329);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,2330);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,2401);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,2402);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,3575);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,3576);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,3577);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,9707);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,9708);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,9716);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,9717);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,9779);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,9780);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,9781);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,9782);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,9783);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,9784);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,9785);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,9786);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,9798);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,9799);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,11697);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11700);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11723);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11724);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11725);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11726);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11727);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11728);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11729);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11730);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11731);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11732);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11733);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11734);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11735);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,11740);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,11744);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11762);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,11766);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11768);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,11771);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,11772);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11774);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11779);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11784);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11789);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11790);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11794);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11800);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11801);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11802);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11803);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,11804);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14481);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,14483);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,14484);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,14485);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,14486);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,14487);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14495);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14556);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14557);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14558);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14559);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14560);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14561);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14562);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14563);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14564);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14565);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14566);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14567);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14568);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14569);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14570);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14571);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14572);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14573);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14574);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14575);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14576);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14577);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14578);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14579);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14580);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14581);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14582);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14583);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14584);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14585);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14586);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14587);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14588);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14589);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14590);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14591);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14592);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14593);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14594);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14595);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14596);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14597);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14598);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14599);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14600);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14601);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14602);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14603);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14604);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14605);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14606);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14607);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14608);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14609);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14610);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14611);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14612);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14613);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14614);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14615);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14616);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14617);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14618);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14619);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14620);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14621);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14622);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14623);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14624);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14625);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14626);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14627);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14628);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14629);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14630);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14631);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14632);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14633);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14634);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14635);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14636);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14637);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14638);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14639);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14640);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14641);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14642);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14643);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14644);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,14645);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,15841);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,15950);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,15951);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,15976);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15983);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,15991);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16025);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16028);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16035);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16036);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16038);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16041);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16043);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16048);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16053);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16054);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16056);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16058);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16060);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16068);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,16069);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,16070);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,16071);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16073);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16074);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16075);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16076);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16077);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16078);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16079);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16088);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16090);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16091);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16095);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16099);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16115);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16116);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16117);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16120);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16125);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16127);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16128);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16132);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16135);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16145);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16147);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16174);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16178);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16181);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16194);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16198);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16203);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16205);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16208);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16209);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16211);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16268);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16280);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16290);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16306);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16312);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16313);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16314);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16317);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16327);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,16335);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16594);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16595);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16931);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16932);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16933);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16934);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16935);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16936);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16937);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16939);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16940);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16941);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16942);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16943);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16944);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16945);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16946);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16947);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16948);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16949);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16950);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16951);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16952);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16953);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16954);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16955);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16956);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16957);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16958);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16959);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16960);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16961);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16962);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16963);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16964);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16965);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16966);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16967);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16968);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16969);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16970);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16971);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16972);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16973);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16974);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16975);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16976);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16977);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16978);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16979);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16980);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16981);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16982);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16983);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16984);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16985);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16986);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16987);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16988);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16989);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16990);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16991);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16992);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16993);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16994);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16995);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16996);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16997);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16998);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16999);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17000);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17001);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17002);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17003);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17004);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17005);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17006);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17007);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17008);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17009);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17010);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17011);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17012);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17014);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17015);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17016);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17017);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17018);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17019);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17020);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17021);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17022);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17023);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17024);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17025);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17026);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17027);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17028);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17029);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17030);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17031);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17032);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17033);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17034);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17035);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17036);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17037);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17038);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17039);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17040);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17041);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17042);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17043);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17044);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17045);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17046);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17047);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17048);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17049);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17050);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17051);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17052);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17053);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17054);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17055);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17056);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17057);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17058);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17059);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17060);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17061);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17062);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17063);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17064);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17065);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17066);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17067);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17068);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17069);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17070);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17071);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17076);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17077);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17078);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17080);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17081);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17082);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17083);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17084);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17085);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17086);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17087);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17088);
commit;

INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17089);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17090);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17091);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17092);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17093);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17094);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17096);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17097);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17098);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17099);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17100);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17101);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,17102);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17103);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17104);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,17105);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17106);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,17107);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,17108);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17109);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17110);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17111);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17112);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17113);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,17114);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17115);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17116);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17117);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17118);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17119);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17120);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,17121);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,17122);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,17123);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,17124);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,17125);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,17126);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,17128);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17129);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17130);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,17131);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,17132);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,17133);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,17134);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17135);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17136);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17137);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17138);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17139);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17140);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17141);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17142);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17143);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17144);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17145);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17146);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17147);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17148);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17149);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17150);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17151);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17152);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17153);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17154);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17155);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17156);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17157);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17158);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17159);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17160);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17161);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17162);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17163);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17164);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17165);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17166);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17167);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17168);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17169);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17171);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17172);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17173);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17174);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17175);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17176);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17177);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17178);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17179);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17180);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17181);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17182);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17183);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17184);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17185);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17186);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17187);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17188);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17189);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17190);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17191);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17192);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17193);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17194);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17195);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17196);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17197);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17198);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17199);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17200);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224012);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224013);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224014);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224015);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224016);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224017);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224018);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224019);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224020);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224021);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224022);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224023);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224024);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224025);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,224026);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323204);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323205);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,323206);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323207);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,323208);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,323209);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,323210);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,323211);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,323212);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,323213);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,323214);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323215);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323217);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323219);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323220);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323222);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323223);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323224);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323225);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323226);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323227);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323228);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323229);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323230);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323231);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323232);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323233);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323235);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323236);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323237);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323238);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323239);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323240);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323241);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323242);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323243);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323244);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323245);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323246);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323247);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323248);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323249);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323250);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,323251);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323252);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323253);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323254);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323255);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323256);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323257);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,323258);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323259);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,323260);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,323261);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,323262);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323263);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323264);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,323265);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323266);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323267);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323268);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323270);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,323273);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,323274);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,323275);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,323276);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,323277);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323279);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323280);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323281);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323282);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323283);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323284);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323285);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323286);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323287);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323288);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323290);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323291);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323292);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323293);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323294);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323295);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323296);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323297);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323298);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323299);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323300);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323301);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323302);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323303);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323304);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323305);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323306);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323307);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323308);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323309);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323310);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323311);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323312);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323313);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323314);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323315);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323316);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323317);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323318);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323319);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323320);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323321);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323322);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323323);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323325);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323326);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323327);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323328);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323329);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323330);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323331);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323332);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323333);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323334);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323335);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323336);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323337);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323338);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323339);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323340);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323341);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323342);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323343);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323344);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323345);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323346);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323347);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323348);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323349);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323350);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323351);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323352);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,323353);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323354);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323355);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323356);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323357);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323358);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323359);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323360);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323361);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323362);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323363);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,323364);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,323365);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323366);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323367);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323368);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323369);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,323370);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,323371);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,323372);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,323373);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323374);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,323375);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,337515);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,337516);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,337517);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,337518);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,337519);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,337520);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,337521);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,337522);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,337523);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,337524);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,337525);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,337526);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,337527);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,337528);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,337529);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,337530);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389161);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389162);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389163);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389164);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389165);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389166);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389167);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389168);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389169);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389170);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389171);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389172);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389173);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389174);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389175);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389176);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389177);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389178);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389179);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389180);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389181);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,389182);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,389183);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389186);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389187);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389189);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389190);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389191);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389192);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389193);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389194);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389196);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389197);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389198);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389199);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389200);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389201);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389202);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389203);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389204);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,389205);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389206);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,389207);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389208);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389209);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389210);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389211);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389212);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389213);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389214);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389215);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389216);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389217);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389218);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389219);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389220);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389221);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389222);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389223);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389224);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389225);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389226);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389227);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389228);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389229);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389230);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389231);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389232);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389233);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389234);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389235);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389236);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389237);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389238);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389239);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389240);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389241);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389242);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389243);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389244);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389245);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389246);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389247);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389248);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389249);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389250);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,389251);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389252);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,389253);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,92);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,102);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,113);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,124);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,137);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,226);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,245);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,259);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,272);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,294);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,368);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,380);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,399);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,407);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,421);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,524);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,550);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,630);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,640);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,651);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,666);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,739);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,746);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,762);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,776);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,786);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,866);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,881);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,893);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,911);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1000);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1010);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1032);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1044);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1117);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1125);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1134);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,1147);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1166);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1248);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1260);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1269);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1283);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1355);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1366);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1379);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1388);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1396);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1407);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1419);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (1,1485);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1495);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1510);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1522);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1529);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1540);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1585);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1676);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1691);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1699);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11757);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,11799);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15886);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,15899);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15909);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15922);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16027);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16040);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16051);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16067);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16148);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16159);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16171);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16183);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16192);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16207);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16267);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16577);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16587);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16921);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,18);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,84);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,114);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,173);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,232);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,271);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,310);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,352);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,434);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,472);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,514);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,635);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,671);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,696);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,734);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,770);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,814);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,855);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,879);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,908);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,955);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,983);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1004);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1043);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1053);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1076);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1090);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1110);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1176);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1194);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1219);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1241);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1284);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1307);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1329);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1351);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1374);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1399);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,1421);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1435);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1479);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1524);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1604);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1647);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1677);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,1713);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,11701);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,11743);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,11796);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,14502);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15857);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15871);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15902);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15926);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,15946);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16003);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16032);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16062);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16087);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16122);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16144);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16168);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16196);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16271);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16302);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16563);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,16582);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,337514);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (2,97);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (8,16288);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (5,16334);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,16938);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,17170);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (7,323271);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,7);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,40);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,71);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,126);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,161);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,207);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,225);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,263);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,322);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,385);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,451);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,487);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,523);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,645);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,701);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,759);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,838);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1014);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (3,1119);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1156);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1261);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1467);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (11,1515);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1597);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1646);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,1696);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,16105);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17079);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (9,17095);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (6,332);
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (10,201);
commit;

/* 03/11/2007 -GT
--measure N entries
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) VALUES (4,201);
insert into characteristic_chartype (fk_chartype,fk_characteristic) values (4,1);
insert into characteristic_chartype (fk_chartype,fk_characteristic) values (4,329);
insert into characteristic_chartype (fk_chartype,fk_characteristic) values (4,464);
insert into characteristic_chartype (fk_chartype,fk_characteristic) values (4,1473);
insert into characteristic_chartype (fk_chartype,fk_characteristic) values (4,11737);
insert into characteristic_chartype (fk_chartype,fk_characteristic) values (4,481);
insert into characteristic_chartype (fk_chartype,fk_characteristic) values (4,3577);
insert into characteristic_chartype (fk_chartype,fk_characteristic) values (4,9717);
insert into characteristic_chartype (fk_chartype,fk_characteristic) values (4,9780);
insert into characteristic_chartype (fk_chartype,fk_characteristic) values (4,137);
insert into characteristic_chartype (fk_chartype,fk_characteristic) values (4,514);
*/
commit;

insert into characteristic_chartype (fk_chartype,fk_characteristic)
select (select pk_isn from lu_chartype where chartype='Biological'), pk_isn
from di_characteristic where type_code='T';
COMMIT;
/* moved up to avoid any bad data.
ALTER TABLE CHARACTERISTIC_CHARTYPE ADD CONSTRAINT CFK_CHARTYPE FOREIGN KEY (FK_CHARTYPE) REFERENCING LU_CHARTYPE(PK_ISN);

ALTER TABLE CHARACTERISTIC_CHARTYPE ADD CONSTRAINT CFK_CHAR FOREIGN KEY (FK_CHARACTERISTIC) REFERENCING DI_CHARACTERISTIC(PK_ISN);

CREATE INDEX UICCT01 ON CHARACTERISTIC_CHARTYPE(FK_CHARTYPE,FK_CHARACTERISTIC)
TABLESPACE STORETINDX
STORAGE (INITIAL 2 m NEXT 2M);
*/

--added on 05/29/2007 -GT
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389254  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389255  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389256  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389257  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389258  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389259  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389262  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389261  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389263  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389264  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389265  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389266  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389267  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389268  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389269  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389270  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389271  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389272  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389273  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389274  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389275  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389276  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389277  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389278  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389279  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389280  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389281  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389282  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389283  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389284  from lu_chartype where chartype='PCB';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389285  from lu_chartype where chartype='PCB';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389286  from lu_chartype where chartype='Nutrient';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389287  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389288  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389289  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389290  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389291  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389292  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389293  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389295  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389296  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389297  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389298  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389301  from lu_chartype where chartype='Habitat';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389302  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389303  from lu_chartype where chartype='Habitat';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389305  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389306  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389307  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389308  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389304  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389310  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389311  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389312  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389315  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389316  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389317  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389318  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389319  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389320  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389321  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389322  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389323  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389324  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389325  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389326  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389327  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389328  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389329  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389330  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389331  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389332  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389333  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389334  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389335  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389336  from lu_chartype where chartype='Pesticide';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389337  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389339  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389340  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389341  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389342  from lu_chartype where chartype='Other';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389346  from lu_chartype where chartype='Radiation';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389348  from lu_chartype where chartype='Radiation';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389349  from lu_chartype where chartype='Radiation';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389351  from lu_chartype where chartype='Habitat';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389352  from lu_chartype where chartype='Habitat';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389353  from lu_chartype where chartype='Habitat';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389354  from lu_chartype where chartype='Habitat';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389355  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389356  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389357  from lu_chartype where chartype='Habitat';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389358  from lu_chartype where chartype='Habitat';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389359  from lu_chartype where chartype='Habitat';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389360  from lu_chartype where chartype='Habitat';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389361  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389362  from lu_chartype where chartype='Habitat';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389363  from lu_chartype where chartype='Habitat';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389364  from lu_chartype where chartype='Physical';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389347  from lu_chartype where chartype='Radiation';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 389350  from lu_chartype where chartype='Radiation';
INSERT INTO CHARACTERISTIC_CHARTYPE (FK_CHARTYPE,FK_CHARACTERISTIC) select pk_isn, 999999  from lu_chartype where chartype='Habitat';


spool off;
